/* ============ */
/* getinitd.c	*/
/* ============ */
#include <defcodes.h>
#include <math.h>
#include <time.h>
#include <miscdefs.h>
#
#define FULL_SIZE ((unsigned)RAND_MAX + 1U)

/* the seed */
#define	ANSI_BASE_SEED	161803398
unsigned long _Randseed = ANSI_BASE_SEED;

/* -------------------------------------------- */
/* ANSI_rand - From Plauger, Standard C Library */
/* -------------------------------------------- */
static
int	(ANSI_rand) (void)
{					/* ANSI Random Numbers */
    /* ANSI-Specified Generator */
    _Randseed = _Randseed * 1103515245 + 12345;
    return ((unsigned int) (_Randseed >> 16) & RAND_MAX);
}
/* -------------------------------------- */
/* Comb_rand - Jerry Dwyer, CUJ June 1995 */
/* -------------------------------------- */
static
int	(Comb_rand) (void)
{
    return ((int)(rand_comb() >> 12) & RAND_MAX);
}
/* ------------------------------------------- */
/* DEK_rand - From Knuth vol 2, p 102, line 26 */
/* ------------------------------------------- */
static
int	(DEK_rand) (void)
{					/* Knuth Random Numbers */
    /* Knuth Generator */
    _Randseed = _Randseed * 1664525 + 1;
    return ((unsigned int) ((_Randseed >> 12) & RAND_MAX));
}
/* ------------------------------------------ */
/* Fib_rand - Fibonacci Sequence, Knuth p. 26 */
/* ------------------------------------------ */
static
int	(Fib_rand) (void)
{
    static  unsigned long  OlderSeed;
    static  unsigned long  OldSeed = (ANSI_BASE_SEED*3)/2;
    OlderSeed = OldSeed;
    OldSeed   = _Randseed;
    _Randseed += OlderSeed;
    return ((unsigned int) (_Randseed >> 8 & RAND_MAX));
}
/* ------------------------------------------ */
/* Hi_rand - From Knuth vol 2, p 102, line 27 */
/* ------------------------------------------ */
static
int	(Hi_rand) (void)
{
    long double RandProd;
    RandProd = (double)_Randseed * 314159269. + 1;
    _Randseed = (unsigned long) fmodl(RandProd, 2147483647.);
    return ((unsigned int) (_Randseed >> 8 & RAND_MAX));
}
/* -------------------------------------- */
/* Port_rand - Jerry Dwyer, CUJ June 1995 */
/* -------------------------------------- */
static
int	(Port_rand) (void)
{
    return ((int)(rand_port() >> 12) & RAND_MAX);
}
/* ------------------------------------------- */
/* R250_rand - Linear Shift Register Generator */
/* ------------------------------------------- */
static
int	(R250_rand) (void)
{
    return ((int)(dRand250() * (double)FULL_SIZE) & RAND_MAX);
}
/* --------------------------------------------- */
/* Randu - Classic Lousy Generator, Knuth p. 104 */
/* --------------------------------------------- */
static
int	(Randu) (void)
{
    _Randseed = (_Randseed * 65539L) % (long)(1L << 31);
    return ((unsigned int) ((_Randseed >> 8) & RAND_MAX));
}
/* ------------------------------------ */
/* SLM_rand - Steve Moshier's Generator */
/* ------------------------------------ */
static
int	(SLM_rand) (void)
{
    int     RandSTD;
    double  RandSLM;

    drand(&RandSLM);			/* Returns variate in [1,2) */

    RandSTD =
	(int)(RandSLM * (double)FULL_SIZE - (double)FULL_SIZE);
    return (RandSTD & RAND_MAX);
}
/* -------------------------------------- */
/* SUB_rand - Knuth Subtractive Generator */
/* -------------------------------------- */
static
int	(SUB_rand) (void)
{
    return (Irand55((long *)&_Randseed));
}
#include <qrmrand.c>
#define	CASE_A	"ANSI_rand() (PJP)"
#define	CASE_C	"Dwyer Combination (CUJ 6/95)"
#define	CASE_F	"Math77 (Fortran)"
#define	CASE_G	"Marsaglia-Zaman-Tsang Ranmar"
#define	CASE_H	"Knuth Line 27"
#define	CASE_I	"Fibonacci Sequence (Knuth p. 26)"
#define	CASE_J	"Marsaglia-Zaman-James VLP"
#define	CASE_K	"Knuth Line 26"
#define	CASE_L	"Linear Shift Register"
#define	CASE_M	"Moshier drand()"
#define	CASE_P	"Dwyer Portable (CUJ 6/95)"
#define	CASE_R	"Run-Time Lib rand()"
#define	CASE_S	"Knuth Subtractive"
#define	CASE_U	"Original Randu (Knuth p. 104)"
#define	CASE_4	"Approximate-Factoring Algorithm # 4"

/* ==================================================================== */
/* GetInitialData - Returns initial input parameters for test functions	*/
/* ==================================================================== */
void
GetInitialData(INIT_DATA_STRU  *InitialData)
{
    char    RandSpec = 0;

    GetInt("Enter Starting Seed (-1 for time): ",
	(int *)&InitialData->SeedSrce);
    fprintf(stderr, "\n");
    GetChr("Enter Generator Desired:"
	"\n\tA = "CASE_A
	"\n\tC = "CASE_C
	"\n\tF = "CASE_F
	"\n\tG = "CASE_G
	"\n\tH = "CASE_H
	"\n\tI = "CASE_I
	"\n\tJ = "CASE_J
	"\n\tK = "CASE_K
	"\n\tL = "CASE_L
	"\n\tM = "CASE_M
	"\n\tP = "CASE_P
	"\n\tR = "CASE_R
	"\n\tS = "CASE_S
	"\n\tU = "CASE_U
	"\n\t4 = "CASE_4
	"\n\tElse (None of the Above) "CASE_R": ",
		&RandSpec);

    if (InitialData->SeedSrce == (UINT)(-1))
    {
	time_t	MyTime = time(NULL);
	InitialData->UserSeed = (UINT)MyTime;
    }
    else
    {
	InitialData->UserSeed = InitialData->SeedSrce;
    }

    _Randseed += InitialData->UserSeed;

    switch (toupper(RandSpec))
    {
    case 'A':                            /* ANSI_rand() (PJP) */
	InitialData->RandFun = ANSI_rand;
	InitialData->GenName = CASE_A;
	break;
    case 'C':
	InitialData->RandFun = Comb_rand;
	InitialData->GenName = CASE_C;
	init_rand_comb((long)InitialData->UserSeed,
		(long)InitialData->UserSeed);
	break;
    case 'F':
	InitialData->RandFun = iM77_rand;
	InitialData->GenName = CASE_F;
	M77_rand_init(InitialData->UserSeed);
	break;
    case 'G':
	InitialData->RandFun = Iranmar;
	InitialData->GenName = CASE_G;
	rmarin(InitialData->UserSeed, InitialData->UserSeed);
	break;
    case 'H':
	InitialData->RandFun = Hi_rand;
	InitialData->GenName = CASE_H;
	break;
    case 'I':
	InitialData->RandFun = Fib_rand;
	InitialData->GenName = CASE_I;
	break;
    case 'J':
	InitialData->RandFun = IRand_MZ;
	InitialData->GenName = CASE_J;
	Rand_MZ_Init(_Randseed);
	break;
    case 'K':
	InitialData->RandFun = DEK_rand;
	InitialData->GenName = CASE_K;
	break;
    case 'L':
	InitialData->RandFun = R250_rand;
	InitialData->GenName = CASE_L;
	Rand250_init(InitialData->UserSeed);
	break;
    case 'M':
	InitialData->RandFun = SLM_rand;
	InitialData->GenName = CASE_M;
	DrandSeed(InitialData->UserSeed);	/* Initialize Generator */
	break;
    case 'P':
	InitialData->RandFun = Port_rand;
	InitialData->GenName = CASE_P;
	init_rand_port(InitialData->UserSeed);
	break;
    default:
    case 'R':
	srand(InitialData->UserSeed);		/* Initialize Generator */
	InitialData->RandFun = rand;
	InitialData->GenName = CASE_R;
	break;
    case 'S':
	InitialData->RandFun = SUB_rand;
	InitialData->GenName = CASE_S;
	break;
    case 'U':
	InitialData->RandFun = Randu;
	InitialData->GenName = CASE_U;
	break;
    case '4':
	InitialData->RandFun = Qrm4_rand;
	InitialData->GenName = CASE_4;
	break;
    }
}
